from bpy.types import PropertyGroup
from bpy.props import IntProperty, FloatProperty, BoolProperty


class ActiveEmitterPhysicsAnimProps(PropertyGroup):
    
    """ active_emitter_item.phyisics.anim.x """

    timestep_start: IntProperty(name="Start", description="Start at Frame", default=1)
    timestep_duration: IntProperty(name="Duration", description="Duration", default=10)
    timestep_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    timestep_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    timestep_from: FloatProperty(name="From", description="From value x", default=0.04)
    timestep_to: FloatProperty(name="To", description="To value x", default=0.0001)
    timestep_animed: BoolProperty(default=False)
    timestep_inc_dec: BoolProperty(default=False)

    subframes_start: IntProperty(name="Start", description="Start at Frame", default=1)
    subframes_duration: IntProperty(name="Duration", description="Duration", default=10)
    subframes_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    subframes_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    subframes_from: IntProperty(name="From", description="From value x", default=4)
    subframes_to: IntProperty(name="To", description="To value x", default=8)
    subframes_animed: BoolProperty(default=False)
    subframes_inc_dec: BoolProperty(default=False)

    stiffness_start: IntProperty(name="Start", description="Start at Frame", default=1)
    stiffness_duration: IntProperty(name="Duration", description="Duration", default=10)
    stiffness_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    stiffness_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    stiffness_from: FloatProperty(name="From", description="From value x", default=0.04)
    stiffness_to: FloatProperty(name="To", description="To value x", default=0.0001)
    stiffness_animed: BoolProperty(default=False)
    stiffness_inc_dec: BoolProperty(default=False)

    linear_viscosity_start: IntProperty(name="Start", description="Start at Frame", default=1)
    linear_viscosity_duration: IntProperty(name="Duration", description="Duration", default=10)
    linear_viscosity_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    linear_viscosity_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    linear_viscosity_from: FloatProperty(name="From", description="From value x", default=0.04)
    linear_viscosity_to: FloatProperty(name="To", description="To value x", default=0.0001)
    linear_viscosity_animed: BoolProperty(default=False)
    linear_viscosity_inc_dec: BoolProperty(default=False)

    fluid_radius_start: IntProperty(name="Start", description="Start at Frame", default=1)
    fluid_radius_duration: IntProperty(name="Duration", description="Duration", default=10)
    fluid_radius_increase: IntProperty(name="Increase", description="Frames of the increment", default=1)
    fluid_radius_decrease: IntProperty(name="Decrease", description="Frames of the decrement", default=1)
    fluid_radius_from: FloatProperty(name="From", description="From value x", default=0.04)
    fluid_radius_to: FloatProperty(name="To", description="To value x", default=0.0001)
    fluid_radius_animed: BoolProperty(default=False)
    fluid_radius_inc_dec: BoolProperty(default=False)